/*
 * Decompiled with CFR 0.152.
 */
package wildrush;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import wildrush.GraphicModule;
import wildrush.WildRush;

public class StartPage
extends JPanel {
    private WildRush Parent;
    private JButton btnStart = new JButton("Play");
    private JButton btnHelp = new JButton("How To Play");
    private JButton btnAbout = new JButton("About");
    private JButton btnSoundControl = new JButton("Sounds: ON");
    private JButton btnExit = new JButton("Exit Game");
    private ClickCatcher cc = new ClickCatcher();
    private GraphicModule GM;
    private ImageIcon Logo;
    private Image PanelBackground;

    public StartPage(WildRush p) {
        System.out.println("");
        System.out.println("> StartPage : Load");
        this.Parent = p;
        this.GM = new GraphicModule();
        this.Logo = this.GM.get("logo_wildrush.png");
        this.PanelBackground = this.GM.get("wallpaper_cheetah.jpg").getImage();
        this.setLayout(new BorderLayout());
        JPanel MenuPanel = new JPanel();
        MenuPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        Dimension ButtonDim = new Dimension(200, 40);
        this.btnStart.setPreferredSize(ButtonDim);
        this.btnHelp.setPreferredSize(ButtonDim);
        this.btnAbout.setPreferredSize(ButtonDim);
        this.btnSoundControl.setPreferredSize(ButtonDim);
        this.btnExit.setPreferredSize(ButtonDim);
        this.btnStart.addActionListener(this.cc);
        this.btnHelp.addActionListener(this.cc);
        this.btnAbout.addActionListener(this.cc);
        this.btnSoundControl.addActionListener(this.cc);
        this.btnExit.addActionListener(this.cc);
        JLabel WRLogo = new JLabel(this.Logo);
        WRLogo.setPreferredSize(new Dimension(500, 200));
        this.add((Component)WRLogo, "North");
        gbc.gridx = 0;
        gbc.gridy = 0;
        MenuPanel.add((Component)this.btnStart, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        MenuPanel.add((Component)this.btnHelp, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        MenuPanel.add((Component)this.btnAbout, gbc);
        this.btnAbout.setVisible(false);
        gbc.gridx = 0;
        gbc.gridy = 3;
        MenuPanel.add((Component)this.btnExit, gbc);
        gbc.weighty = 25.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        MenuPanel.add((Component)new JLabel(""), gbc);
        MenuPanel.setOpaque(false);
        this.add((Component)MenuPanel, "Center");
        JLabel Footer = new JLabel("<html><b>Version 1.0&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By Patrick Jinon &copy; 2013&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;www.charex.net/wildrush</b></html>");
        Footer.setHorizontalAlignment(0);
        Footer.setPreferredSize(new Dimension(500, 30));
        this.add((Component)Footer, "South");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.PanelBackground, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    private class ClickCatcher
    implements ActionListener {
        private ClickCatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == StartPage.this.btnStart) {
                ((StartPage)StartPage.this).Parent.Stack.show(((StartPage)StartPage.this).Parent.CardPanel, "PreGame");
            } else if (ae.getSource() == StartPage.this.btnHelp) {
                Desktop desktop;
                String TutorialURL = "http://www.charex.net/wildrush/howtoplay";
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(new URI(TutorialURL));
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        JOptionPane.showMessageDialog(null, "Could not open URL: " + TutorialURL + "\n\n" + e, "Error", 0);
                    }
                }
            } else if (ae.getSource() == StartPage.this.btnAbout) {
                ((StartPage)StartPage.this).Parent.Stack.show(((StartPage)StartPage.this).Parent.CardPanel, "About");
            } else if (ae.getSource() != StartPage.this.btnSoundControl && ae.getSource() == StartPage.this.btnExit) {
                System.exit(0);
            }
        }
    }
}

