/*
 * Decompiled with CFR 0.152.
 */
package wildrush;

import java.awt.Image;
import java.util.ArrayList;
import wildrush.Animal;
import wildrush.GraphicModule;
import wildrush.Modifier;

public class Map {
    private Tile[] MapTiles;
    private Terrain[] Terrains;
    private Animal[] Animals;
    private GraphicModule GM = new GraphicModule();
    protected int MapStart;
    protected int MapEnd;

    public Map(int[] MapData, Animal[] Animals) {
        int i;
        this.MapTiles = new Tile[MapData.length + 8];
        this.MapStart = 0;
        this.MapEnd = MapData.length;
        this.Animals = Animals;
        this.Terrains = new Terrain[10];
        this.Terrains[0] = new Terrain("Grassland", "");
        this.Terrains[0].Background = this.GM.get("terrain_grassland.gif").getImage();
        this.Terrains[1] = new Terrain("River", "");
        this.Terrains[1].Background = this.GM.get("terrain_river.gif").getImage();
        Modifier RiverBoost = new Modifier();
        RiverBoost.setName("River Boost");
        RiverBoost.setInfo("Field Resistance is increased by 40%");
        RiverBoost.ResistanceToFieldModifier = "+40";
        this.Terrains[1].BoostMod = RiverBoost;
        this.Terrains[2] = new Terrain("Rainforest", "");
        this.Terrains[2].Background = this.GM.get("terrain_rainforest.gif").getImage();
        Modifier RainForestBoost = new Modifier();
        RainForestBoost.setName("Rainforest Boost");
        RainForestBoost.setInfo("Field Resistance is increased by 60%");
        RainForestBoost.ResistanceToFieldModifier = "+60";
        Modifier RainForestBuffer = new Modifier();
        RainForestBuffer.setName("Rainforest Buffer");
        RainForestBuffer.setInfo("Movement is reduced by 1 at the beginning of each turn");
        RainForestBuffer.MovementModifier = "-1";
        this.Terrains[2].BoostMod = RainForestBoost;
        this.Terrains[2].BufferMod = RainForestBuffer;
        this.Terrains[3] = new Terrain("Cave", "");
        this.Terrains[3].Background = this.GM.get("terrain_cave.gif").getImage();
        Modifier CaveBuffer = new Modifier();
        CaveBuffer.setName("Cave Buffer");
        CaveBuffer.setInfo("All Resistances are dropped to 0");
        CaveBuffer.ResistanceToFieldModifier = "=0";
        CaveBuffer.ResistanceToTripModifier = "=0";
        CaveBuffer.ResistanceToEncounterModifier = "=0";
        this.Terrains[3].BufferMod = CaveBuffer;
        this.Terrains[4] = new Terrain("Savannah", "");
        this.Terrains[4].Background = this.GM.get("terrain_savannah.gif").getImage();
        this.Terrains[4].Affects = new String[]{Animals[0].getName(), Animals[1].getName(), Animals[2].getName()};
        Modifier SavannahBoost = new Modifier();
        SavannahBoost.setName("Savannah Boost");
        SavannahBoost.setInfo("Encounter Resistance is increased by 40%");
        SavannahBoost.ResistanceToEncounterModifier = "+40";
        this.Terrains[4].BoostMod = SavannahBoost;
        this.Terrains[5] = new Terrain("Desert", "");
        this.Terrains[5].Background = this.GM.get("terrain_desert.gif").getImage();
        Modifier DesertBuffer = new Modifier();
        DesertBuffer.setName("Desert Buffer");
        DesertBuffer.setInfo("Stamina Cost is increased by 1");
        DesertBuffer.StaminaCostModifier = "+1";
        this.Terrains[5].BufferMod = DesertBuffer;
        this.Terrains[6] = new Terrain("Volcano", "");
        this.Terrains[6].Background = this.GM.get("terrain_volcano.gif").getImage();
        Modifier VolcanoBuffer = new Modifier();
        VolcanoBuffer.setName("Volcano Buffer");
        VolcanoBuffer.setInfo("Movement is decreased by 1 at the beginning of each turn");
        VolcanoBuffer.MovementModifier = "-1";
        this.Terrains[6].BufferMod = VolcanoBuffer;
        this.Terrains[7] = new Terrain("Mountain", "");
        this.Terrains[7].Background = this.GM.get("terrain_mountain.gif").getImage();
        Modifier MountainBuffer = new Modifier();
        MountainBuffer.setName("Mountain Buffer");
        MountainBuffer.setInfo("Stamina Cost is increased by 1");
        MountainBuffer.StaminaCostModifier = "+1";
        this.Terrains[7].BufferMod = MountainBuffer;
        this.Terrains[8] = new Terrain("Boreal Forest", "");
        this.Terrains[8].Background = this.GM.get("terrain_boreal.gif").getImage();
        this.Terrains[8].Affects = new String[]{Animals[3].getName()};
        Modifier BorealBoost = new Modifier();
        BorealBoost.setName("Boreal Boost");
        BorealBoost.setInfo("Movement is increased by 1 at the beginning of each turn");
        BorealBoost.MovementModifier = "+1";
        Modifier BorealBuffer = new Modifier();
        BorealBuffer.setName("Boreal Buffer");
        BorealBuffer.setInfo("Movement is reduced by 1 at the beginning of each turn");
        BorealBuffer.MovementModifier = "-1";
        this.Terrains[8].BoostMod = BorealBoost;
        this.Terrains[8].BufferMod = BorealBuffer;
        this.Terrains[9] = new Terrain("Glacier", "");
        this.Terrains[9].Background = this.GM.get("terrain_glacier.gif").getImage();
        Modifier GlacierBuffer = new Modifier();
        GlacierBuffer.setName("Glacier Buffer");
        GlacierBuffer.setInfo("Movement is reduced by 1 at the beginning of each turn. Stamina drops by 2 at the beginning of each turn");
        GlacierBuffer.MovementModifier = "-1";
        GlacierBuffer.StaminaModifier = "-2";
        this.Terrains[9].BufferMod = GlacierBuffer;
        ArrayList<String> BluePrint = new ArrayList<String>();
        BluePrint.add("" + MapData[0]);
        BluePrint.add("" + MapData[0]);
        for (i = 0; i < MapData.length; ++i) {
            BluePrint.add("" + MapData[i]);
        }
        for (i = 0; i < 6; ++i) {
            BluePrint.add("" + MapData[MapData.length - 1]);
        }
        for (i = 0; i < BluePrint.size(); ++i) {
            int ALindex = Integer.parseInt((String)BluePrint.get(i));
            this.MapTiles[i] = new Tile(i, this.Terrains[ALindex]);
        }
    }

    protected Tile getTileAt(int index) {
        return this.MapTiles[index + 1];
    }

    protected void setObstacleAt(int index, Obstacle obs) {
        this.MapTiles[index + 1].setObstacle(obs);
    }

    public class Terrain {
        private String Name = "???";
        private String Info = "???";
        protected Modifier BoostMod = null;
        protected Modifier BufferMod = null;
        protected String[] Affects;
        private Image Background;

        public Terrain(String name, String info) {
            this.Name = name;
            this.Info = info;
            this.Affects = new String[0];
        }

        protected String getName() {
            return this.Name;
        }

        protected Image getImage() {
            return this.Background;
        }

        protected Modifier getBoostGhost() {
            Modifier Ghost = new Modifier();
            Ghost.setName(this.BoostMod.getName());
            Ghost.setInfo(this.BoostMod.getInfo());
            Ghost.MovementModifier = this.BoostMod.MovementModifier;
            Ghost.StaminaCostModifier = this.BoostMod.StaminaCostModifier;
            Ghost.StaminaModifier = this.BoostMod.StaminaModifier;
            Ghost.TurnDelayModifier = this.BoostMod.TurnDelayModifier;
            Ghost.ResistanceToFieldModifier = this.BoostMod.ResistanceToFieldModifier;
            Ghost.ResistanceToTripModifier = this.BoostMod.ResistanceToTripModifier;
            Ghost.ResistanceToEncounterModifier = this.BoostMod.ResistanceToEncounterModifier;
            return Ghost;
        }

        protected Modifier getBufferGhost() {
            Modifier Ghost = new Modifier();
            Ghost.setName(this.BufferMod.getName());
            Ghost.setInfo(this.BufferMod.getInfo());
            Ghost.MovementModifier = this.BufferMod.MovementModifier;
            Ghost.StaminaCostModifier = this.BufferMod.StaminaCostModifier;
            Ghost.StaminaModifier = this.BufferMod.StaminaModifier;
            Ghost.TurnDelayModifier = this.BufferMod.TurnDelayModifier;
            Ghost.ResistanceToFieldModifier = this.BufferMod.ResistanceToFieldModifier;
            Ghost.ResistanceToTripModifier = this.BufferMod.ResistanceToTripModifier;
            Ghost.ResistanceToEncounterModifier = this.BufferMod.ResistanceToEncounterModifier;
            return Ghost;
        }
    }

    public static class Obstacle {
        public static final int OBSTACLE_FIELD = 0;
        public static final int OBSTACLE_TRIP = 1;
        public static final int OBSTACLE_ENCOUNTER = 2;
        private String Name = "???";
        private String Info = "???";
        private int Type;
        protected int TurnDelay = 0;
        protected int StaminaDrop = 0;

        public Obstacle(String name, String info, int type) {
            this.Name = name;
            this.Info = info;
            this.Type = type;
        }

        protected Obstacle ghost() {
            Obstacle o = new Obstacle(this.Name, this.Info, this.Type);
            o.TurnDelay = this.TurnDelay;
            o.StaminaDrop = this.StaminaDrop;
            return o;
        }

        protected int getType() {
            return this.Type;
        }
    }

    public class Tile {
        private int TileNo;
        private Terrain Terra;
        private Obstacle Obs;

        public Tile(int Index, Terrain t) {
            this.TileNo = Index;
            this.Terra = t;
            this.Obs = null;
        }

        protected int getTileIndex() {
            return this.TileNo;
        }

        protected Terrain getTerrain() {
            return this.Terra;
        }

        protected boolean hasObstacle() {
            return this.Obs != null;
        }

        protected Obstacle getObstacle() {
            return this.Obs;
        }

        protected void setObstacle(Obstacle ob) {
            this.Obs = ob;
        }
    }
}

