/*
 * Decompiled with CFR 0.152.
 */
package wildrush;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import wildrush.Animal;
import wildrush.GameProper;
import wildrush.GraphicModule;
import wildrush.Player;
import wildrush.WildRush;

public class GameStart
extends JPanel {
    private WildRush Parent;
    private Animal[] Animals;
    private GraphicModule GM;
    private Image PanelBackground;
    private JPanel[] AnimalPanels;
    private Player[] Players;
    private JComboBox[] CmbPlayerName;
    private AnimalComboChecker ACC = new AnimalComboChecker();
    private JLabel[] LblPlayerImage = new JLabel[4];
    private JLabel LblPlayerController;
    private String[] CmbPlayerControllerStrings = new String[]{"Player", "Computer"};
    private JComboBox[] CmbPlayerController = new JComboBox[4];
    private JLabel LblPlayerTurnOrder;
    private String[] CmbPlayerTurnOrderStrings = new String[]{"Random", "1", "2", "3", "4"};
    private JComboBox[] CmbPlayerTurnOrder = new JComboBox[4];
    private TurnOrderComboChecker TOCC = new TurnOrderComboChecker();
    private JButton btnBack = new JButton("<html><b>Back</b></html>");
    private JButton btnStart = new JButton("<html><b>Start Game</b></html>");
    private ClickCatcher CC = new ClickCatcher();

    public GameStart(WildRush p, Animal[] AnimalData) {
        int i;
        System.out.println("");
        System.out.println("> GameStart : Load");
        this.Parent = p;
        this.GM = new GraphicModule();
        this.PanelBackground = this.GM.get("wallpaper_cheetah.jpg").getImage();
        this.Animals = AnimalData;
        this.CmbPlayerName = new JComboBox[this.Animals.length];
        String[] AnimalNames = new String[this.Animals.length];
        for (i = 0; i < this.Animals.length; ++i) {
            AnimalNames[i] = this.Animals[i].getName();
        }
        for (i = 0; i < this.CmbPlayerName.length; ++i) {
            this.CmbPlayerName[i] = new JComboBox<String>(AnimalNames);
        }
        this.AnimalPanels = new JPanel[this.Animals.length];
        Dimension PanelDimension = new Dimension(320, 200);
        GridBagConstraints AnimalPanelGbc = new GridBagConstraints();
        AnimalPanelGbc.fill = 2;
        AnimalPanelGbc.insets = new Insets(5, 5, 5, 5);
        for (int i2 = 0; i2 < this.AnimalPanels.length; ++i2) {
            this.AnimalPanels[i2] = new JPanel();
            this.AnimalPanels[i2].setOpaque(false);
            this.AnimalPanels[i2].setPreferredSize(PanelDimension);
            this.AnimalPanels[i2].setBorder(BorderFactory.createTitledBorder("Player " + (i2 + 1)));
            this.AnimalPanels[i2].setLayout(new GridBagLayout());
            this.CmbPlayerName[i2].setSelectedItem(this.Animals[i2].getName());
            this.CmbPlayerName[i2].setPreferredSize(new Dimension(120, 30));
            AnimalPanelGbc.gridx = 0;
            AnimalPanelGbc.gridy = 0;
            this.AnimalPanels[i2].add((Component)this.CmbPlayerName[i2], AnimalPanelGbc);
            this.CmbPlayerName[i2].addActionListener(this.ACC);
            this.LblPlayerImage[i2] = new JLabel();
            this.LblPlayerImage[i2].setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.LblPlayerImage[i2].setIcon(this.Animals[i2].getAvatar());
            AnimalPanelGbc.gridx = 1;
            AnimalPanelGbc.gridy = 0;
            this.AnimalPanels[i2].add((Component)this.LblPlayerImage[i2], AnimalPanelGbc);
            this.CmbPlayerController[i2] = new JComboBox<String>(this.CmbPlayerControllerStrings);
            if (i2 == 0) {
                this.CmbPlayerController[i2].setSelectedIndex(0);
            } else {
                this.CmbPlayerController[i2].setSelectedIndex(1);
            }
            this.LblPlayerController = new JLabel("Controller");
            AnimalPanelGbc.gridx = 0;
            AnimalPanelGbc.gridy = 1;
            this.AnimalPanels[i2].add((Component)this.LblPlayerController, AnimalPanelGbc);
            AnimalPanelGbc.gridx = 1;
            AnimalPanelGbc.gridy = 1;
            this.AnimalPanels[i2].add((Component)this.CmbPlayerController[i2], AnimalPanelGbc);
            this.CmbPlayerTurnOrder[i2] = new JComboBox<String>(this.CmbPlayerTurnOrderStrings);
            this.CmbPlayerTurnOrder[i2].setSelectedIndex(0);
            this.LblPlayerTurnOrder = new JLabel("Turn Order");
            AnimalPanelGbc.gridx = 0;
            AnimalPanelGbc.gridy = 2;
            this.AnimalPanels[i2].add((Component)this.LblPlayerTurnOrder, AnimalPanelGbc);
            AnimalPanelGbc.gridx = 1;
            AnimalPanelGbc.gridy = 2;
            this.AnimalPanels[i2].add((Component)this.CmbPlayerTurnOrder[i2], AnimalPanelGbc);
            this.CmbPlayerTurnOrder[i2].addActionListener(this.TOCC);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.AnimalPanels[0], gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.AnimalPanels[1], gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.AnimalPanels[2], gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.AnimalPanels[3], gbc);
        Dimension ButtonDim = new Dimension(200, 40);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.btnBack.setPreferredSize(ButtonDim);
        this.btnBack.addActionListener(this.CC);
        this.add((Component)this.btnBack, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.btnStart.setPreferredSize(ButtonDim);
        this.btnStart.addActionListener(this.CC);
        this.add((Component)this.btnStart, gbc);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.PanelBackground, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    static /* synthetic */ Player[] access$802(GameStart x0, Player[] x1) {
        x0.Players = x1;
        return x1;
    }

    private class ClickCatcher
    implements ActionListener {
        private ClickCatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == GameStart.this.btnStart) {
                int i;
                GameStart.access$802(GameStart.this, new Player[4]);
                Player[] TempPlayers = new Player[4];
                for (int i2 = 0; i2 < GameStart.this.CmbPlayerName.length; ++i2) {
                    TempPlayers[i2] = new Player(i2 + 1);
                    for (int j = 0; j < GameStart.this.Animals.length; ++j) {
                        if (!GameStart.this.CmbPlayerName[i2].getSelectedItem().toString().equals(GameStart.this.Animals[j].getName())) continue;
                        TempPlayers[i2].setAnimal(GameStart.this.Animals[j].ghost());
                    }
                    if (!GameStart.this.CmbPlayerController[i2].getSelectedItem().toString().equals("Computer")) continue;
                    TempPlayers[i2].setAI(true);
                }
                String[] TurnOrder = new String[4];
                for (i = 0; i < TurnOrder.length; ++i) {
                    TurnOrder[i] = GameStart.this.CmbPlayerTurnOrder[i].getSelectedItem().toString();
                }
                for (i = 0; i < TurnOrder.length; ++i) {
                    if (!TurnOrder[i].equals("Random")) continue;
                    String rn = "Random";
                    while (Arrays.asList(TurnOrder).contains(rn)) {
                        Random ra = new Random();
                        rn = "" + (1 + ra.nextInt(4));
                    }
                    TurnOrder[i] = rn;
                }
                for (i = 0; i < TurnOrder.length; ++i) {
                    int index = Integer.parseInt(TurnOrder[i]) - 1;
                    ((GameStart)GameStart.this).Players[index] = TempPlayers[i];
                }
                ((GameStart)GameStart.this).Parent.CardPanel.add((Component)new GameProper(GameStart.this.Parent, GameStart.this.Players, GameStart.this.Animals), "GameProper");
                ((GameStart)GameStart.this).Parent.Stack.show(((GameStart)GameStart.this).Parent.CardPanel, "GameProper");
            } else if (ae.getSource() == GameStart.this.btnBack) {
                ((GameStart)GameStart.this).Parent.Stack.show(((GameStart)GameStart.this).Parent.CardPanel, "Start");
            }
        }
    }

    private class TurnOrderComboChecker
    implements ActionListener {
        private TurnOrderComboChecker() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            for (int i = 0; i < GameStart.this.CmbPlayerTurnOrder.length; ++i) {
                Object SelectedItem;
                if (ae.getSource() != GameStart.this.CmbPlayerTurnOrder[i] || (SelectedItem = GameStart.this.CmbPlayerTurnOrder[i].getSelectedItem()).toString().equals("Random")) continue;
                for (int j = 0; j < GameStart.this.CmbPlayerTurnOrder.length; ++j) {
                    if (!GameStart.this.CmbPlayerTurnOrder[j].getSelectedItem().toString().equals(SelectedItem.toString()) || j == i) continue;
                    GameStart.this.CmbPlayerTurnOrder[j].setSelectedItem("Random");
                }
            }
        }
    }

    private class AnimalComboChecker
    implements ActionListener {
        private AnimalComboChecker() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            for (int i = 0; i < GameStart.this.CmbPlayerName.length; ++i) {
                if (ae.getSource() != GameStart.this.CmbPlayerName[i]) continue;
                GameStart.this.LblPlayerImage[i].setIcon(GameStart.this.Animals[GameStart.this.CmbPlayerName[i].getSelectedIndex()].getAvatar());
            }
        }
    }
}

