/*
 * Decompiled with CFR 0.152.
 */
package wildrush;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import wildrush.Animal;
import wildrush.Extras;
import wildrush.GraphicModule;
import wildrush.Map;
import wildrush.Modifier;
import wildrush.NoteWindow;
import wildrush.Player;
import wildrush.Skill;
import wildrush.Spirit;
import wildrush.WildRush;

public class GameProper
extends JPanel {
    private WildRush Parent;
    private NoteWindow NW;
    private GraphicModule GM;
    private ClickCatcher CC = new ClickCatcher();
    private Thread GameThread;
    private Map GameMap;
    private int Turn = 0;
    private Player ActivePlayer;
    private Skill[] ActiveSkills;
    private boolean Pause = false;
    private int Phase;
    private ModHook MH;
    private boolean HasMoved = false;
    private boolean HasUsedActiveSkill = false;
    private boolean HasTileTriggered = false;
    private Player[] Players;
    private Animal[] Animals;
    private JPanel NorthPanel = new JPanel();
    private JButton NPBtnPlayers = new JButton("Players");
    private JButton NPBtnMap = new JButton("View Map");
    private JButton NPBtnHelp = new JButton("Help");
    private JButton NPBtnQuit = new JButton("Quit Game");
    private JPanel FieldPanel;
    private JPanel ActionPanel = new JPanel();
    private JButton APBtnTile = new JButton("Tile Info");
    private JButton APBtnMove = new JButton("Move");
    private JButton APBtnRest = new JButton("Rest");
    private JLabel APLblAnimalIcon = new JLabel();
    private JButton[] APBtnSkill = new JButton[2];
    private JButton APBtnEndTurn = new JButton("End Turn");
    private JPanel[] AnimalPanel = new JPanel[4];
    private JProgressBar[] APProgressBar = new JProgressBar[4];
    private JLabel[] APLblState = new JLabel[4];
    private JLabel[] APLblResistanceField = new JLabel[4];
    private JLabel[] APLblResistanceTrip = new JLabel[4];
    private JLabel[] APLblResistanceEncounter = new JLabel[4];
    private JLabel[] APLblTurnDelay = new JLabel[4];
    private JLabel[] APLblMovement = new JLabel[4];
    private ImageIcon APIcoStateFainted;
    private ImageIcon APIcoStateExhausted;
    private ImageIcon APIcoStateRest;
    private ImageIcon APIcoStateNormal;
    private ImageIcon APIcoStateAdrenaline;
    private ImageIcon APIcoResistanceField;
    private ImageIcon APIcoResistanceTrip;
    private ImageIcon APIcoResistanceEncounter;
    private ImageIcon APIcoTD;
    private ImageIcon APIcoMov;

    public GameProper(WildRush p, Player[] Players, Animal[] Animals) {
        System.out.println("");
        System.out.println("> GameProper : Load");
        System.out.println("--> Player Turn Order");
        for (int i = 0; i < Players.length; ++i) {
            System.out.println("----> " + (i + 1) + " - Player " + Players[i].getID() + ": " + Players[i].getAnimal().getName());
        }
        this.Parent = p;
        this.Players = Players;
        this.Animals = Animals;
        this.GM = new GraphicModule();
        this.APIcoStateFainted = this.GM.get("icon_state_fainted.gif");
        this.APIcoStateExhausted = this.GM.get("icon_state_exhausted.gif");
        this.APIcoStateRest = this.GM.get("icon_state_rest.gif");
        this.APIcoStateNormal = this.GM.get("icon_state_normal.gif");
        this.APIcoStateAdrenaline = this.GM.get("icon_state_adrenaline.gif");
        this.APIcoResistanceField = this.GM.get("icon_resistance_field.gif");
        this.APIcoResistanceTrip = this.GM.get("icon_resistance_trip.gif");
        this.APIcoResistanceEncounter = this.GM.get("icon_resistance_encounter.gif");
        this.APIcoMov = this.GM.get("icon_dice.gif");
        this.APIcoTD = this.GM.get("icon_dice_no.gif");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 200.0;
        this.NorthPanel = this.getNorthPanel();
        this.add((Component)this.NorthPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.FieldPanel = new FieldPanel();
        this.FieldPanel.setPreferredSize(new Dimension(700, 360));
        this.FieldPanel.setBackground(Color.decode("#aaffaa"));
        this.add((Component)this.FieldPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.ActionPanel = this.getActionPanel();
        this.add((Component)this.ActionPanel, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 50.0;
        for (int i = 0; i < Players.length; ++i) {
            this.AnimalPanel[i] = new JPanel();
            this.AnimalPanel[i].setLayout(new GridBagLayout());
            this.AnimalPanel[i].setBackground(Color.decode("#ccbb99"));
            this.AnimalPanel[i].setBorder(BorderFactory.createTitledBorder("Player " + Players[i].getID() + ": " + Players[i].getAnimal().getName()));
            GridBagConstraints APgbc = new GridBagConstraints();
            APgbc.fill = 1;
            APgbc.insets = new Insets(2, 2, 2, 2);
            this.APProgressBar[i] = new JProgressBar(0, Players[i].getAnimal().getMaximumStamina());
            this.APProgressBar[i].setValue(Players[i].getAnimal().getStamina());
            this.APProgressBar[i].setString(Players[i].getAnimal().getStamina() + " / " + Players[i].getAnimal().getMaximumStamina());
            this.APProgressBar[i].setStringPainted(true);
            APgbc.gridwidth = 3;
            APgbc.gridx = 0;
            APgbc.gridy = 0;
            this.AnimalPanel[i].add((Component)this.APProgressBar[i], APgbc);
            APgbc.gridx = 0;
            APgbc.gridy = 1;
            this.APLblState[i] = new JLabel("State: ");
            this.AnimalPanel[i].add((Component)this.APLblState[i], APgbc);
            Dimension LabelDims = new Dimension(42, 24);
            APgbc.gridwidth = 1;
            APgbc.gridx = 0;
            APgbc.gridy = 2;
            this.APLblResistanceField[i] = new JLabel("FR: ");
            this.APLblResistanceField[i].setPreferredSize(LabelDims);
            this.APLblResistanceField[i].setIcon(this.APIcoResistanceField);
            this.AnimalPanel[i].add((Component)this.APLblResistanceField[i], APgbc);
            APgbc.gridx = 1;
            APgbc.gridy = 2;
            this.APLblResistanceTrip[i] = new JLabel("TR: ");
            this.APLblResistanceTrip[i].setPreferredSize(LabelDims);
            this.APLblResistanceTrip[i].setIcon(this.APIcoResistanceTrip);
            this.AnimalPanel[i].add((Component)this.APLblResistanceTrip[i], APgbc);
            APgbc.gridx = 2;
            APgbc.gridy = 2;
            this.APLblResistanceEncounter[i] = new JLabel("ER: ");
            this.APLblResistanceEncounter[i].setPreferredSize(LabelDims);
            this.APLblResistanceEncounter[i].setIcon(this.APIcoResistanceEncounter);
            this.AnimalPanel[i].add((Component)this.APLblResistanceEncounter[i], APgbc);
            APgbc.gridx = 0;
            APgbc.gridy = 3;
            this.APLblTurnDelay[i] = new JLabel("TD: ");
            this.APLblTurnDelay[i].setIcon(this.APIcoTD);
            this.APLblTurnDelay[i].setPreferredSize(LabelDims);
            this.AnimalPanel[i].add((Component)this.APLblTurnDelay[i], APgbc);
            APgbc.gridx = 1;
            APgbc.gridy = 3;
            this.APLblMovement[i] = new JLabel("MOV: ");
            this.APLblMovement[i].setPreferredSize(LabelDims);
            this.APLblMovement[i].setIcon(this.APIcoMov);
            this.AnimalPanel[i].add((Component)this.APLblMovement[i], APgbc);
            gbc.gridx = i;
            gbc.gridy = 3;
            this.add((Component)this.AnimalPanel[i], gbc);
        }
        this.GameThread = new Thread(new Game());
        this.GameThread.start();
    }

    private JPanel getNorthPanel() {
        JPanel NP = new JPanel();
        NP.setBackground(Color.decode("#cc9933"));
        NP.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, Color.decode("#665533")));
        NP.setPreferredSize(new Dimension(700, 40));
        NP.setLayout(new FlowLayout(3));
        NP.add(this.NPBtnPlayers);
        NP.add(this.NPBtnMap);
        NP.add(this.NPBtnHelp);
        NP.add(this.NPBtnQuit);
        this.NPBtnPlayers.setVisible(false);
        this.NPBtnMap.setVisible(false);
        this.NPBtnHelp.setVisible(false);
        this.NPBtnPlayers.addActionListener(this.CC);
        this.NPBtnMap.addActionListener(this.CC);
        this.NPBtnHelp.addActionListener(this.CC);
        this.NPBtnQuit.addActionListener(this.CC);
        return NP;
    }

    private JPanel getActionPanel() {
        JPanel AP = new JPanel();
        AP.setBackground(Color.decode("#cc9933"));
        AP.setBorder(BorderFactory.createMatteBorder(3, 0, 2, 0, Color.decode("#665533")));
        AP.setPreferredSize(new Dimension(700, 55));
        AP.setLayout(new GridBagLayout());
        GridBagConstraints APgbc = new GridBagConstraints();
        APgbc.fill = 2;
        this.APBtnSkill[0] = new JButton("Skill Slot1");
        this.APBtnSkill[1] = new JButton("Skill Slot2");
        Dimension APButtonDimension = new Dimension(125, 34);
        this.APBtnTile.setPreferredSize(APButtonDimension);
        this.APBtnMove.setPreferredSize(APButtonDimension);
        this.APBtnRest.setPreferredSize(APButtonDimension);
        this.APBtnSkill[0].setPreferredSize(APButtonDimension);
        this.APBtnSkill[1].setPreferredSize(APButtonDimension);
        this.APBtnEndTurn.setPreferredSize(APButtonDimension);
        this.APBtnTile.setFocusable(false);
        this.APBtnMove.setFocusable(false);
        this.APBtnRest.setFocusable(false);
        this.APBtnSkill[0].setFocusable(false);
        this.APBtnSkill[1].setFocusable(false);
        this.APBtnEndTurn.setFocusable(false);
        APgbc.insets = new Insets(0, 2, 0, 2);
        APgbc.gridy = 0;
        APgbc.gridx = 0;
        AP.add((Component)this.APBtnTile, APgbc);
        this.APBtnTile.setVisible(false);
        APgbc.gridx = 1;
        this.APLblAnimalIcon.setIcon(this.Players[0].getAnimal().getAvatar());
        this.APLblAnimalIcon.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, Color.decode("#665533")));
        AP.add((Component)this.APLblAnimalIcon, APgbc);
        APgbc.gridx = 2;
        AP.add((Component)this.APBtnMove, APgbc);
        APgbc.gridx = 3;
        AP.add((Component)this.APBtnRest, APgbc);
        APgbc.gridx = 4;
        AP.add((Component)this.APBtnSkill[0], APgbc);
        APgbc.gridx = 5;
        AP.add((Component)this.APBtnSkill[1], APgbc);
        APgbc.gridx = 6;
        AP.add((Component)this.APBtnEndTurn, APgbc);
        this.APBtnMove.setMnemonic('M');
        this.APBtnRest.setMnemonic('R');
        this.APBtnEndTurn.setMnemonic('E');
        this.APBtnTile.addActionListener(this.CC);
        this.APBtnMove.addActionListener(this.CC);
        this.APBtnRest.addActionListener(this.CC);
        this.APBtnSkill[0].addActionListener(this.CC);
        this.APBtnEndTurn.addActionListener(this.CC);
        return AP;
    }

    protected void playerActionMove() {
        this.APBtnMove.setEnabled(false);
        this.APBtnRest.setEnabled(false);
        this.APBtnSkill[0].setEnabled(false);
        this.APBtnEndTurn.setEnabled(false);
        ++this.Phase;
        System.out.println("+");
        System.out.println("+----> Phase " + this.Phase + " : Movement");
    }

    protected void playerActionRest() {
        this.APBtnTile.setEnabled(false);
        this.APBtnMove.setEnabled(false);
        this.APBtnRest.setEnabled(false);
        this.APBtnSkill[0].setEnabled(false);
        this.APBtnEndTurn.setEnabled(false);
        this.NW.setNote("Rest");
        this.HasMoved = true;
        this.HasUsedActiveSkill = true;
        this.ActivePlayer.setMovement(0);
        this.ActivePlayer.getAnimal().setStamina(this.ActivePlayer.getAnimal().getStamina() + this.ActivePlayer.getAnimal().getMaximumStamina() / 2);
        this.ActivePlayer.getAnimal().setState(2);
        this.Phase = 4;
    }

    protected void playerActionActiveSkill() {
        int StaminaCost = this.ActiveSkills[0].getStaminaUsage();
        if (this.ActivePlayer.getAnimal().getState() == 4 && (StaminaCost -= 5) < 0) {
            StaminaCost = 0;
        }
        if (this.ActivePlayer.getAnimal().getStamina() <= StaminaCost) {
            JOptionPane.showMessageDialog(null, "Your Stamina is too low to activate this skill!", "Low Stamina", 1);
        } else if (!this.HasUsedActiveSkill) {
            this.ActivePlayer.getAnimal().setStamina(this.ActivePlayer.getAnimal().getStamina() - StaminaCost);
            Modifier ActiveSkillMod = this.ActiveSkills[0].asModifier();
            ActiveSkillMod.setActivationPhase(this.Phase);
            this.MH.addModifier(ActiveSkillMod);
            this.MH.apply();
            this.NW.setNote(this.ActiveSkills[0].getName());
            this.updateGUI();
            this.HasUsedActiveSkill = true;
            this.APBtnSkill[0].setEnabled(false);
            this.APBtnRest.setEnabled(false);
        } else {
            ++this.Phase;
        }
    }

    protected void playerActionEndTurn() {
        this.APBtnTile.setEnabled(false);
        this.APBtnMove.setEnabled(false);
        this.APBtnRest.setEnabled(false);
        this.APBtnSkill[0].setEnabled(false);
        this.APBtnEndTurn.setEnabled(false);
        this.HasMoved = true;
        this.HasUsedActiveSkill = true;
        this.Phase = 4;
    }

    protected void updateGUI() {
        int i;
        System.out.print("+------> Update GUI");
        this.APLblAnimalIcon.setIcon(this.ActivePlayer.getAnimal().getAvatar());
        for (i = 0; i < this.APBtnSkill.length; ++i) {
            this.APBtnSkill[i].setText(this.ActiveSkills[i].getName());
            String SkillType = "Active";
            if (this.ActiveSkills[i].getType() == 0) {
                SkillType = "Passive";
            }
            this.APBtnSkill[i].setToolTipText("<html><b>" + this.ActiveSkills[i].getName() + " [" + SkillType + "]</b><br>" + this.ActiveSkills[i].getInfo() + "</html>");
        }
        for (i = 0; i < this.AnimalPanel.length; ++i) {
            this.APProgressBar[i].setValue(this.Players[i].getAnimal().getStamina());
            this.APProgressBar[i].setString(this.Players[i].getAnimal().getStamina() + " / " + this.Players[i].getAnimal().getMaximumStamina());
            String UpdateState = "Normal";
            ImageIcon UpdateStateIcon = this.APIcoStateNormal;
            switch (this.Players[i].getAnimal().getState()) {
                case 0: {
                    UpdateState = "Fainted";
                    UpdateStateIcon = this.APIcoStateFainted;
                    break;
                }
                case 1: {
                    UpdateState = "Exhausted";
                    UpdateStateIcon = this.APIcoStateExhausted;
                    break;
                }
                case 2: {
                    UpdateState = "Rest";
                    UpdateStateIcon = this.APIcoStateRest;
                    break;
                }
                case 4: {
                    UpdateState = "ADRENALINE";
                    UpdateStateIcon = this.APIcoStateAdrenaline;
                }
            }
            this.APLblState[i].setIcon(UpdateStateIcon);
            this.APLblState[i].setText(UpdateState);
            this.APLblResistanceField[i].setText("" + this.Players[i].getResistanceToField());
            this.APLblResistanceTrip[i].setText("" + this.Players[i].getResistanceToTrip());
            this.APLblResistanceEncounter[i].setText("" + this.Players[i].getResistanceToEncounter());
            this.APLblResistanceField[i].setToolTipText("Field Obstacle Resistance: " + this.Players[i].getResistanceToField() + "%");
            this.APLblResistanceTrip[i].setToolTipText("Trip Obstacle Resistance: " + this.Players[i].getResistanceToTrip() + "%");
            this.APLblResistanceEncounter[i].setToolTipText("Encounter Obstacle Resistance: " + this.Players[i].getResistanceToEncounter() + "%");
            this.APLblTurnDelay[i].setText("" + this.Players[i].getTurnDelay());
            this.APLblTurnDelay[i].setToolTipText("Turn Losses: " + this.Players[i].getTurnDelay());
            this.APLblMovement[i].setText("" + this.Players[i].getMovement());
            this.APLblMovement[i].setToolTipText("Turn Movement: " + this.Players[i].getMovement() + " steps");
        }
        this.FieldPanel.repaint();
        System.out.println(" [OK]");
    }

    protected void setObstacles(Map m) {
        Map.Obstacle Trip = new Map.Obstacle("", "", 1);
        Map.Obstacle Encounter1 = new Map.Obstacle("", "", 2);
        Encounter1.StaminaDrop = 20;
        Encounter1.TurnDelay = 1;
        m.setObstacleAt(15, Encounter1.ghost());
        m.setObstacleAt(20, Encounter1.ghost());
        m.setObstacleAt(30, Encounter1.ghost());
        m.setObstacleAt(36, Trip.ghost());
        m.setObstacleAt(40, Encounter1.ghost());
        m.setObstacleAt(48, Trip.ghost());
        m.setObstacleAt(51, Trip.ghost());
        m.setObstacleAt(54, Trip.ghost());
        m.setObstacleAt(60, Encounter1.ghost());
        m.setObstacleAt(64, Encounter1.ghost());
        m.setObstacleAt(68, Encounter1.ghost());
        m.setObstacleAt(72, Encounter1.ghost());
        m.setObstacleAt(80, Trip.ghost());
        m.setObstacleAt(90, Trip.ghost());
        m.setObstacleAt(100, Encounter1.ghost());
        m.setObstacleAt(105, Trip.ghost());
        m.setObstacleAt(106, Encounter1.ghost());
        m.setObstacleAt(110, Encounter1.ghost());
        m.setObstacleAt(114, Encounter1.ghost());
        m.setObstacleAt(115, Encounter1.ghost());
        m.setObstacleAt(118, Trip.ghost());
        m.setObstacleAt(120, Encounter1.ghost());
        m.setObstacleAt(121, Encounter1.ghost());
        m.setObstacleAt(126, Trip.ghost());
        m.setObstacleAt(129, Encounter1.ghost());
        m.setObstacleAt(130, Encounter1.ghost());
        m.setObstacleAt(131, Encounter1.ghost());
        m.setObstacleAt(135, Trip.ghost());
        m.setObstacleAt(137, Encounter1.ghost());
        m.setObstacleAt(140, Trip.ghost());
        m.setObstacleAt(142, Encounter1.ghost());
        m.setObstacleAt(145, Trip.ghost());
        m.setObstacleAt(146, Encounter1.ghost());
        m.setObstacleAt(147, Encounter1.ghost());
        m.setObstacleAt(148, Encounter1.ghost());
        m.setObstacleAt(149, Encounter1.ghost());
    }

    static /* synthetic */ Skill[] access$1702(GameProper x0, Skill[] x1) {
        x0.ActiveSkills = x1;
        return x1;
    }

    protected class Game
    implements Runnable {
        public static final int PHASE_PREPARE = 0;
        public static final int PHASE_MAIN1 = 1;
        public static final int PHASE_MOVEMENT = 2;
        public static final int PHASE_MAIN2 = 3;
        public static final int PHASE_END = 4;
        private Spirit AI;
        private int AIThinkTime = 1000;

        public Game() {
            System.out.println("");
            System.out.println("**************************************************");
            System.out.println("+                  GAME STARTED                  +");
            System.out.println("+------------------------------------------------+");
            System.out.println("+");
            int[] MapData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            GameProper.this.GameMap = new Map(MapData, GameProper.this.Animals);
            GameProper.this.setObstacles(GameProper.this.GameMap);
            for (int i = 0; i < GameProper.this.Players.length; ++i) {
                GameProper.this.Players[i].setFloor(0);
            }
            GameProper.this.Phase = 0;
            GameProper.this.MH = new ModHook();
            this.AI = new Spirit();
            System.out.println("+--> Initialized");
        }

        protected void processDecision(int i) {
            switch (i) {
                case 1: {
                    GameProper.this.playerActionMove();
                    break;
                }
                case 2: {
                    GameProper.this.playerActionRest();
                    break;
                }
                case 4: {
                    GameProper.this.playerActionEndTurn();
                    break;
                }
                case 3: {
                    GameProper.this.playerActionActiveSkill();
                }
            }
        }

        @Override
        public void run() {
            while (!GameProper.this.Pause) {
                try {
                    switch (GameProper.this.Phase) {
                        case 0: {
                            GameProper.this.ActivePlayer = GameProper.this.Players[GameProper.this.Turn];
                            GameProper.access$1702(GameProper.this, ((GameProper)GameProper.this).ActivePlayer.getAnimal().Skills);
                            GameProper.this.HasMoved = false;
                            GameProper.this.HasUsedActiveSkill = false;
                            System.out.println("+");
                            System.out.println("+");
                            String WhosTurn = "+--> Player " + GameProper.this.ActivePlayer.getID() + "'s Turn : " + GameProper.this.ActivePlayer.getAnimal().getName();
                            System.out.println(WhosTurn.toUpperCase());
                            GameProper.this.updateGUI();
                            GameProper.this.NW = new NoteWindow(GameProper.this.Parent, "Player " + GameProper.this.ActivePlayer.getID() + "'s Turn : " + GameProper.this.ActivePlayer.getAnimal().getName());
                            Thread.sleep(1000L);
                            if (GameProper.this.ActivePlayer.getTurnDelay() > 0) {
                                GameProper.this.ActivePlayer.setTurnDelay(GameProper.this.ActivePlayer.getTurnDelay() - 1);
                                System.out.println("+----> Lost Turn. Delays Left: " + GameProper.this.ActivePlayer.getTurnDelay());
                                GameProper.this.Phase = 4;
                                GameProper.this.NW.setNote("Lost Turn!");
                                Thread.sleep(1000L);
                                break;
                            }
                            System.out.println("+");
                            System.out.println("+----> Phase " + GameProper.this.Phase + " : Prepare");
                            if (GameProper.this.ActivePlayer.isAI()) {
                                GameProper.this.APBtnTile.setEnabled(false);
                                GameProper.this.APBtnMove.setEnabled(false);
                                GameProper.this.APBtnRest.setEnabled(false);
                                GameProper.this.APBtnSkill[0].setEnabled(false);
                                GameProper.this.APBtnEndTurn.setEnabled(false);
                            } else {
                                GameProper.this.APBtnTile.setEnabled(true);
                                GameProper.this.APBtnMove.setEnabled(true);
                                GameProper.this.APBtnRest.setEnabled(true);
                                GameProper.this.APBtnSkill[0].setEnabled(true);
                                GameProper.this.APBtnEndTurn.setEnabled(true);
                            }
                            Random Rand = new Random();
                            int DiceRollResult = 2 + Rand.nextInt(5);
                            System.out.println("+------> Dice Roll: " + DiceRollResult);
                            GameProper.this.Players[GameProper.this.Turn].setMovement(DiceRollResult);
                            for (int i = 0; i < GameProper.this.ActiveSkills.length; ++i) {
                                if (GameProper.this.ActiveSkills[i].getType() != 0 || !GameProper.this.ActiveSkills[i].isEnabled()) continue;
                                Modifier PassiveSkillModifier = GameProper.this.ActiveSkills[i].asModifier();
                                PassiveSkillModifier.setActivationPhase(0);
                                GameProper.this.MH.addModifier(PassiveSkillModifier);
                                System.out.println("+------> Hooked Modifier For Passive Skill: " + GameProper.this.ActiveSkills[i].getName());
                                GameProper.this.APBtnSkill[i].setEnabled(false);
                            }
                            if (((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getTerrain().BoostMod != null) {
                                Map.Terrain Terra = GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).getTerrain();
                                Modifier TerrainBoostMod = Terra.getBoostGhost();
                                TerrainBoostMod.setActivationPhase(0);
                                if (Arrays.asList(Terra.Affects).contains(GameProper.this.ActivePlayer.getAnimal().getName())) {
                                    TerrainBoostMod.setTarget(1);
                                    GameProper.this.MH.addModifier(TerrainBoostMod);
                                }
                            }
                            if (((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getTerrain().BufferMod != null) {
                                Map.Terrain Terra = GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).getTerrain();
                                Modifier TerrainBufferMod = Terra.getBufferGhost();
                                TerrainBufferMod.setActivationPhase(0);
                                if (!Arrays.asList(Terra.Affects).contains(GameProper.this.ActivePlayer.getAnimal().getName())) {
                                    TerrainBufferMod.setTarget(1);
                                    GameProper.this.MH.addModifier(TerrainBufferMod);
                                }
                            }
                            System.out.println("+------> Hooked Modifiers for " + GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).getTerrain().getName() + " Terrain @ Tile #" + GameProper.this.ActivePlayer.getFloor());
                            GameProper.this.MH.apply();
                            if (GameProper.this.ActivePlayer.getAnimal().getState() == 0) {
                                GameProper.this.ActivePlayer.getAnimal().setStamina(1);
                                GameProper.this.ActivePlayer.getAnimal().updateState();
                                GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " got to his senses!");
                                Thread.sleep(1000L);
                            }
                            if (GameProper.this.ActivePlayer.getAnimal().getStamina() < 1) {
                                GameProper.this.ActivePlayer.getAnimal().updateState();
                                GameProper.this.Phase = 4;
                                GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " fainted!");
                                Thread.sleep(1000L);
                            }
                            if (GameProper.this.ActivePlayer.getAnimal().getState() == 2) {
                                GameProper.this.ActivePlayer.getAnimal().updateState();
                                GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " woke up!");
                                Thread.sleep(1000L);
                            }
                            System.out.println("+------> Adrenaline Chance");
                            if (GameProper.this.ActivePlayer.getAnimal().getState() == 3) {
                                if (Extras.calcChanceByDice(20)) {
                                    System.out.println("+--------> Success! Adrenaline Rush granted.");
                                    GameProper.this.ActivePlayer.getAnimal().setState(4);
                                    GameProper.this.NW.setNote("Adrenaline Rush!");
                                    Thread.sleep(1000L);
                                } else {
                                    System.out.println("+--------> Adrenaline Rush NOT granted.");
                                }
                            } else if (GameProper.this.ActivePlayer.getAnimal().getState() == 1) {
                                if (Extras.calcChanceByDice(4)) {
                                    System.out.println("+--------> Success! Adrenaline Rush granted.");
                                    GameProper.this.ActivePlayer.getAnimal().setState(4);
                                    GameProper.this.NW.setNote("Adrenaline Rush!");
                                    Thread.sleep(1000L);
                                } else {
                                    System.out.println("+--------> Adrenaline Rush NOT granted.");
                                }
                            }
                            if (GameProper.this.ActivePlayer.isAI()) {
                                this.AI.possess(GameProper.this.ActivePlayer);
                            }
                            GameProper.this.NW.hide();
                            GameProper.this.updateGUI();
                            GameProper.this.Phase++;
                            System.out.println("+");
                            System.out.println("+----> Phase " + GameProper.this.Phase + " : Main 1");
                            System.out.println("+------> Waiting for user action");
                            break;
                        }
                        case 1: {
                            if (!GameProper.this.ActivePlayer.isAI()) break;
                            this.AI.setPhase(GameProper.this.Phase);
                            this.processDecision(this.AI.getDecision());
                            Thread.sleep(this.AIThinkTime);
                            break;
                        }
                        case 2: {
                            GameProper.this.NW.hide();
                            if (GameProper.this.ActivePlayer.getMovement() > 0) {
                                GameProper.this.ActivePlayer.move();
                                GameProper.this.updateGUI();
                                if (GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).hasObstacle() && GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).getObstacle().getType() == 1 && Extras.calcChanceByPercentage(100 - GameProper.this.ActivePlayer.getResistanceToField())) {
                                    System.out.println("+------> Player " + GameProper.this.ActivePlayer.getID() + " tripped at Tile #" + GameProper.this.ActivePlayer.getFloor());
                                    GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " tripped and fell!");
                                    Thread.sleep(1000L);
                                    GameProper.this.ActivePlayer.setMovement(0);
                                    GameProper.this.Phase = 4;
                                }
                                if (GameProper.this.ActivePlayer.getFloor() != ((GameProper)GameProper.this).GameMap.MapEnd) break;
                                GameProper.this.GameThread.interrupt();
                                GameProper.this.Pause = true;
                                JOptionPane.showMessageDialog(null, "Game Over!\nPlayer " + GameProper.this.ActivePlayer.getID() + ": " + GameProper.this.ActivePlayer.getAnimal().getName() + " won!");
                                break;
                            }
                            System.out.println("+------> Stopped");
                            GameProper.this.HasMoved = true;
                            GameProper.this.Phase++;
                            System.out.println("+");
                            System.out.println("+----> Phase " + GameProper.this.Phase + " : Main 2");
                            break;
                        }
                        case 3: {
                            if (GameProper.this.HasUsedActiveSkill || GameProper.this.ActivePlayer.getAnimal().getStamina() <= GameProper.this.ActiveSkills[0].getStaminaUsage()) {
                                GameProper.this.Phase++;
                                break;
                            }
                            if (!GameProper.this.APBtnSkill[0].isEnabled() && !GameProper.this.ActivePlayer.isAI()) {
                                GameProper.this.APBtnSkill[0].setEnabled(true);
                                GameProper.this.APBtnEndTurn.setEnabled(true);
                            }
                            if (!GameProper.this.ActivePlayer.isAI()) break;
                            this.AI.setPhase(GameProper.this.Phase);
                            this.processDecision(this.AI.getDecision());
                            Thread.sleep(this.AIThinkTime);
                            break;
                        }
                        case 4: {
                            if (GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).hasObstacle() && GameProper.this.GameMap.getTileAt(GameProper.this.ActivePlayer.getFloor()).getObstacle().getType() == 2 && GameProper.this.ActivePlayer.getAnimal().getState() != 2 && GameProper.this.ActivePlayer.getAnimal().getState() != 0 && GameProper.this.HasMoved) {
                                if (Extras.calcChanceByPercentage(100 - GameProper.this.ActivePlayer.getResistanceToEncounter())) {
                                    Object[] options;
                                    int c;
                                    GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " met an encounter!");
                                    Thread.sleep(1000L);
                                    GameProper.this.NW.hide();
                                    System.out.println("+------> Player " + GameProper.this.ActivePlayer.getID() + " met an encounter at Tile #" + GameProper.this.ActivePlayer.getFloor());
                                    boolean Run = false;
                                    if (GameProper.this.ActivePlayer.isAI()) {
                                        if (GameProper.this.ActivePlayer.getAnimal().getStamina() > ((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getObstacle().StaminaDrop) {
                                            Run = true;
                                        }
                                    } else if (GameProper.this.ActivePlayer.getAnimal().getStamina() > ((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getObstacle().StaminaDrop && (c = JOptionPane.showOptionDialog(null, "You met an encounter!", "Encounter Obstacle!", 0, 3, null, options = new Object[]{"Evade it and run!", "Fend it off!"}, options[0])) == 0) {
                                        Run = true;
                                    }
                                    if (!Run) {
                                        GameProper.this.ActivePlayer.setTurnDelay(((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getObstacle().TurnDelay);
                                        GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " stood his ground!");
                                        Thread.sleep(1000L);
                                        System.out.println("+--------> Decision: Fend it off");
                                    } else {
                                        GameProper.this.ActivePlayer.getAnimal().setStamina(GameProper.this.ActivePlayer.getAnimal().getStamina() - ((GameProper)GameProper.this).GameMap.getTileAt((int)((GameProper)GameProper.this).ActivePlayer.getFloor()).getObstacle().StaminaDrop);
                                        GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " fled the encounter!");
                                        Thread.sleep(1000L);
                                        System.out.println("+--------> Decision: Run");
                                    }
                                } else {
                                    GameProper.this.NW.setNote("Player " + GameProper.this.ActivePlayer.getID() + " avoided an encounter!");
                                    Thread.sleep(1000L);
                                    System.out.println("+------> Player " + GameProper.this.ActivePlayer.getID() + " avoided an encounter at Tile #" + GameProper.this.ActivePlayer.getFloor());
                                }
                                GameProper.this.NW.hide();
                            }
                            if (GameProper.this.ActivePlayer.getAnimal().getState() == 4) {
                                GameProper.this.ActivePlayer.getAnimal().updateState();
                            }
                            System.out.println("+");
                            System.out.println("+----> Phase " + GameProper.this.Phase + " : End Phase");
                            GameProper.this.MH.apply();
                            GameProper.this.ActivePlayer.resetBuffs();
                            System.out.println("+------> Resetting Buffs");
                            GameProper.this.Phase = 0;
                            if (GameProper.this.Turn >= 3) {
                                GameProper.this.Turn = 0;
                            } else {
                                GameProper.this.Turn++;
                            }
                            GameProper.this.NW.dispose();
                            GameProper.this.updateGUI();
                            System.out.println("+------> Turn End");
                        }
                    }
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    GameProper.this.Pause = true;
                    System.out.println("+");
                    System.out.println("+--> Quit");
                    System.out.println("+");
                    System.out.println("+------------------------------------------------+");
                    System.out.println("+                  GAME STOPPED                  +");
                    System.out.println("**************************************************");
                    System.out.println("");
                }
            }
        }
    }

    private class ModHook {
        private Player[] TargetPlayers;
        private ArrayList<Modifier> ModList = new ArrayList();

        protected void addModifier(Modifier NewModifier) {
            this.ModList.add(NewModifier);
        }

        protected Modifier[] getModList() {
            Modifier[] modArray = new Modifier[this.ModList.size()];
            for (int i = 0; i < modArray.length; ++i) {
                modArray[i] = this.ModList.get(i);
            }
            return modArray;
        }

        protected int calcModifier(int CurrentValue, String Mod) {
            double r = 0.0;
            char Operator = Mod.charAt(0);
            double Factor = Double.parseDouble(Mod.substring(1));
            switch (Operator) {
                case '+': {
                    r = (double)CurrentValue + Factor;
                    break;
                }
                case '-': {
                    r = (double)CurrentValue - Factor;
                    break;
                }
                case '*': {
                    r = (double)CurrentValue * Factor;
                    break;
                }
                case '/': {
                    r = (double)CurrentValue / Factor;
                    break;
                }
                case '=': {
                    r = Factor;
                }
            }
            return (int)Math.floor(r);
        }

        protected void apply() {
            int j;
            ArrayList<String> EraseQ = new ArrayList<String>();
            System.out.println("+------> Applying Phase " + GameProper.this.Phase + " Modifiers");
            for (int i = 0; i < this.ModList.size(); ++i) {
                Modifier Mod = this.ModList.get(i);
                if (Mod.getDuration() != 0 && Mod.getActivationPhase() == GameProper.this.Phase) {
                    int j2;
                    System.out.println("+--------> " + Mod.getName().toUpperCase());
                    if (Mod.getTarget() == 1) {
                        this.TargetPlayers = new Player[1];
                        this.TargetPlayers[0] = GameProper.this.Players[GameProper.this.Turn];
                    } else if (Mod.getTarget() == 2) {
                        this.TargetPlayers = new Player[3];
                        int Iter = 0;
                        for (int j3 = 0; j3 < GameProper.this.Players.length; ++j3) {
                            if (j3 == GameProper.this.Turn) continue;
                            this.TargetPlayers[Iter] = GameProper.this.Players[j3];
                            ++Iter;
                        }
                    } else if (Mod.getTarget() == 3) {
                        this.TargetPlayers = GameProper.this.Players;
                    } else if (Mod.getTarget() == 4) {
                        Animal[] Exceptions = Mod.getTargetExceptions();
                        ArrayList<Player> ExemptedPlayers = new ArrayList<Player>();
                        for (j2 = 0; j2 < GameProper.this.Players.length; ++j2) {
                            if (!Arrays.asList(Exceptions).contains(GameProper.this.Players[j2].getAnimal())) continue;
                            ExemptedPlayers.add(GameProper.this.Players[j2]);
                        }
                        this.TargetPlayers = new Player[ExemptedPlayers.size()];
                        for (j2 = 0; j2 < this.TargetPlayers.length; ++j2) {
                            this.TargetPlayers[j2] = (Player)ExemptedPlayers.get(j2);
                        }
                    } else if (Mod.getTarget() == 5) {
                        Animal[] Exceptions = Mod.getTargetExceptions();
                        ArrayList<Player> ExemptedPlayers = new ArrayList<Player>();
                        for (j2 = 0; j2 < GameProper.this.Players.length; ++j2) {
                            if (Arrays.asList(Exceptions).contains(GameProper.this.Players[j2].getAnimal())) continue;
                            ExemptedPlayers.add(GameProper.this.Players[j2]);
                        }
                        this.TargetPlayers = new Player[ExemptedPlayers.size()];
                        for (j2 = 0; j2 < this.TargetPlayers.length; ++j2) {
                            this.TargetPlayers[j2] = (Player)ExemptedPlayers.get(j2);
                        }
                    }
                    for (j = 0; j < this.TargetPlayers.length; ++j) {
                        System.out.println("+----------> Player " + this.TargetPlayers[j].getID() + ": " + this.TargetPlayers[j].getAnimal().getName());
                        System.out.print("+----------> Stamina: " + this.TargetPlayers[j].getAnimal().getStamina() + " => ");
                        int curValue = this.calcModifier(this.TargetPlayers[j].getAnimal().getStamina(), Mod.StaminaModifier);
                        this.TargetPlayers[j].getAnimal().setStamina(curValue);
                        System.out.println(this.TargetPlayers[j].getAnimal().getStamina());
                        System.out.print("+----------> Movement: " + this.TargetPlayers[j].getMovement() + " => ");
                        curValue = this.calcModifier(this.TargetPlayers[j].getMovement(), Mod.MovementModifier);
                        this.TargetPlayers[j].setMovement(curValue);
                        System.out.println(this.TargetPlayers[j].getMovement());
                        System.out.print("+----------> Turn Delay: " + this.TargetPlayers[j].getTurnDelay() + " => ");
                        curValue = this.calcModifier(this.TargetPlayers[j].getTurnDelay(), Mod.TurnDelayModifier);
                        this.TargetPlayers[j].setTurnDelay(curValue);
                        System.out.println(this.TargetPlayers[j].getTurnDelay());
                        System.out.print("+----------> Stamina Cost: " + this.TargetPlayers[j].getStaminaCost() + " => ");
                        curValue = this.calcModifier(0, Mod.StaminaCostModifier);
                        this.TargetPlayers[j].setStaminaCostBuff(curValue);
                        System.out.println(this.TargetPlayers[j].getStaminaCost());
                        System.out.print("+----------> Resistance To Field: " + this.TargetPlayers[j].getResistanceToField() + " => ");
                        curValue = this.calcModifier(this.TargetPlayers[j].getResistanceToField(), Mod.ResistanceToFieldModifier);
                        this.TargetPlayers[j].setResistanceToFieldBuff(curValue);
                        System.out.println(this.TargetPlayers[j].getResistanceToField());
                        System.out.print("+----------> Resistance To Trip: " + this.TargetPlayers[j].getResistanceToTrip() + " => ");
                        curValue = this.calcModifier(this.TargetPlayers[j].getResistanceToTrip(), Mod.ResistanceToTripModifier);
                        this.TargetPlayers[j].setResistanceToTripBuff(curValue);
                        System.out.println(this.TargetPlayers[j].getResistanceToTrip());
                        System.out.print("+----------> Resistance To Encounter: " + this.TargetPlayers[j].getResistanceToEncounter() + " => ");
                        curValue = this.calcModifier(this.TargetPlayers[j].getResistanceToEncounter(), Mod.ResistanceToEncounterModifier);
                        this.TargetPlayers[j].setResistanceToEncounterBuff(curValue);
                        System.out.println(this.TargetPlayers[j].getResistanceToEncounter());
                    }
                    if (Mod.getDuration() > 0) {
                        Mod.setDuration(Mod.getDuration() - 1);
                        this.ModList.set(i, Mod);
                    }
                }
                if (Mod.getDuration() != 0) continue;
                System.out.println("+--------> Queued " + Mod.getName() + " for erasing");
                EraseQ.add("" + i);
            }
            Collections.reverse(EraseQ);
            int ErasedMods = 0;
            for (int i = 0; i < EraseQ.size(); ++i) {
                j = Integer.parseInt((String)EraseQ.get(i));
                this.ModList.remove(j);
                ++ErasedMods;
            }
            System.out.println("+--------> " + ErasedMods + " Modifiers removed");
            System.out.println("+------> Phase " + GameProper.this.Phase + " Modifiers Applied");
        }
    }

    private class ClickCatcher
    implements ActionListener {
        private ClickCatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() != GameProper.this.NPBtnPlayers && ae.getSource() != GameProper.this.NPBtnMap && ae.getSource() != GameProper.this.NPBtnHelp) {
                if (ae.getSource() == GameProper.this.NPBtnQuit) {
                    int ConfirmQuit = JOptionPane.showConfirmDialog(null, "Are you sure you want to quit the game?", "Quit Game", 0);
                    if (ConfirmQuit == 0) {
                        while (GameProper.this.GameThread.isAlive()) {
                            GameProper.this.GameThread.interrupt();
                        }
                        GameProper.this.GameThread = null;
                        ((GameProper)GameProper.this).Parent.Stack.show(((GameProper)GameProper.this).Parent.CardPanel, "Start");
                        ((GameProper)GameProper.this).Parent.CardPanel.remove(((GameProper)GameProper.this).Parent.CardPanel.getComponents().length - 1);
                    }
                } else if (ae.getActionCommand().equals("Move")) {
                    GameProper.this.playerActionMove();
                } else if (ae.getActionCommand().equals("Rest")) {
                    GameProper.this.playerActionRest();
                } else if (ae.getActionCommand().equals("End Turn")) {
                    GameProper.this.playerActionEndTurn();
                } else if (ae.getSource() == GameProper.this.APBtnSkill[0]) {
                    GameProper.this.playerActionActiveSkill();
                }
            }
        }
    }

    private class FieldPanel
    extends JPanel {
        private int FPWidth = this.getWidth();
        private int FPHeight = this.getHeight();
        private int TileW = this.FPWidth / this.TilesPerRow;
        private int TileH = this.FPHeight / 4;
        private int TilesPerRow = 7;
        private ImageIcon IconField;
        private ImageIcon IconTrip;
        private ImageIcon IconEnc;

        public FieldPanel() {
            this.IconTrip = GameProper.this.GM.get("icon_obstacle_trip.gif");
            this.IconEnc = GameProper.this.GM.get("icon_obstacle_encounter.gif");
            this.setLayout(new GridLayout(4, this.TilesPerRow));
            Dimension TileDimension = new Dimension(this.TileW, this.TileH);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < this.TilesPerRow; ++j) {
                    JLabel TileLabel = new JLabel();
                    if (j == 1) {
                        TileLabel.setIcon(GameProper.this.Players[i].getAnimal().getSprite());
                    }
                    TileLabel.setPreferredSize(TileDimension);
                    this.add(TileLabel);
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            this.FPWidth = this.getWidth();
            this.FPHeight = this.getHeight();
            this.TileW = this.FPWidth / this.TilesPerRow;
            this.TileH = this.FPHeight / 4;
            int i = 0;
            Font StrFont = new Font("Verdana", 1, 10);
            for (int y = 0; y < this.FPHeight; y += this.TileH) {
                int renderTile = GameProper.this.Players[i].getFloor() - 1;
                for (int x = 0; x < this.FPWidth; x += this.TileW) {
                    g.drawImage(GameProper.this.GameMap.getTileAt(renderTile).getTerrain().getImage(), x, y, this.TileW, this.TileH, this);
                    if (GameProper.this.GameMap.getTileAt(renderTile).hasObstacle()) {
                        Image ObsImg;
                        switch (GameProper.this.GameMap.getTileAt(renderTile).getObstacle().getType()) {
                            case 2: {
                                ObsImg = this.IconEnc.getImage();
                                break;
                            }
                            case 1: {
                                ObsImg = this.IconTrip.getImage();
                                break;
                            }
                            default: {
                                ObsImg = null;
                            }
                        }
                        g.drawImage(ObsImg, x + 25, y + 40, ObsImg.getWidth(this), ObsImg.getHeight(this), this);
                    }
                    g.setColor(Color.white);
                    g.setFont(StrFont);
                    String TileStr = "";
                    if (renderTile >= 0 && renderTile <= 150) {
                        TileStr = TileStr + renderTile;
                    }
                    g.drawString(TileStr, x + 30, y + (this.TileH - 5));
                    ++renderTile;
                }
                if (i >= GameProper.this.Players.length - 1) continue;
                ++i;
            }
        }
    }
}

